/********************************************************
 *  LESS.C                                              *
 *  By hrakann                                        *
 ********************************************************/
#include	<sys/nearptr.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<dos.h>
#include	<math.h>
#define VIDEO_INT				 0x10		  /* the BIOS video interrupt. */
#define WRITE_DOT				 0x0C		  /* BIOS func to plot a pixel. */
#define SET_MODE				 0x00		  /* BIOS func to set the video mode. */
#define VGA_256_COLOR_MODE	 0x13		  /* use to set 256-color mode. */
#define TEXT_MODE				 0x03		  /* use to set 80x25 text mode. */
#define SCREEN_WIDTH			 320		  /* width in pixels of mode 0x13 */
#define SCREEN_HEIGHT		 200		  /* height in pixels of mode 0x13 */
#define NUM_COLORS			 256		 /* number of colors in mode 0x13 */
#define sgn(x)	((x<0)?-1:((x>0)?1:0)) /* macro to return the sign of a
                                         number */
typedef unsigned char  byte;
typedef unsigned short word;
typedef long			  fixed16_16;
fixed16_16 SIN_ACOS[1024];

byte *VGA=(byte *)0xA0000000L;		  /* this points to video memory. */


/**************************************************************************
 *  set_mode                                                              *
 *     Sets the video mode.                                               *
 **************************************************************************/

void set_mode(byte mode)
{
  union REGS regs;

  regs.h.ah	= SET_MODE;
  regs.h.al	= mode;
  int86(VIDEO_INT, &regs, &regs);
}
/**************************************************************************
 *  plot_pixel                                                            *
 *    Plot a pixel by directly writing to video memory, with no           *
 *    multiplication.                                                     *
 **************************************************************************/

void plot_pixel(int x,int y,byte	color)
{
  /*  y*320 = y*256 + y*64 = y*2^8 + y*2^6   */
  VGA[(y<<8)+(y<<6)+x]=color;
}
/**************************************************************************
 *  circle_slow                                                           *
 *    Draws a circle by using floating point numbers and math fuctions.   *
 **************************************************************************/

void circle_slow(int	x,int	y,	int radius,	byte color)
{
  float n=0,invradius=1/(float)radius;
  int	dx=0,dy=radius-1;
  word dxoffset,dyoffset,offset=(y<<8)+(y<<6)+x;

  while (dx<=dy)
  {
	 dxoffset =	(dx<<8) + (dx<<6);
	 dyoffset =	(dy<<8) + (dy<<6);
	 VGA[offset+dy-dxoffset] =	color;  /* octant 0 */
	 VGA[offset+dx-dyoffset] =	color;  /* octant 1 */
	 VGA[offset-dx-dyoffset] =	color;  /* octant 2 */
	 VGA[offset-dy-dxoffset] =	color;  /* octant 3 */
	 VGA[offset-dy+dxoffset] =	color;  /* octant 4 */
	 VGA[offset-dx+dyoffset] =	color;  /* octant 5 */
	 VGA[offset+dx+dyoffset] =	color;  /* octant 6 */
	 VGA[offset+dy+dxoffset] =	color;  /* octant 7 */
	 dx++;
	 n+=invradius;
	 dy=radius * sin(acos(n));
  }
}
/**************************************************************************
 *  line_slow                                                             *
 *    draws a line using multiplication and division.                     *
 **************************************************************************/

void line_slow(int x1, int	y1, int x2,	int y2, byte color)
{
  int	dx,dy,sdx,sdy,px,py,dxabs,dyabs,i;
  float slope;

  dx=x2-x1;		  /* the horizontal distance of the line */
  dy=y2-y1;		  /* the vertical distance of the line */
  dxabs=abs(dx);
  dyabs=abs(dy);
  sdx=sgn(dx);
  sdy=sgn(dy);
  if (dxabs>=dyabs) /* the line is more horizontal than vertical */
  {
	 slope=(float)dy / (float)dx;
	 for(i=0;i!=dx;i+=sdx)
	 {
		px=i+x1;
		py=slope*i+y1;
		plot_pixel(px,py,color);
	 }
  }
  else /* the line is more vertical than horizontal */
  {
	 slope=(float)dx / (float)dy;
	 for(i=0;i!=dy;i+=sdy)
	 {
		px=slope*i+x1;
		py=i+y1;
		plot_pixel(px,py,color);
	 }
  }
}




/**********************************
 *             Main               *
 *                                *
 **********************************/


void main()
{
	int x,y,radius,color,i,ii,x1,y1,x2,y2,q;
   char c;
	if	(__djgpp_nearptr_enable() == 0)
								 exit(-1);

							  VGA=(byte	*)(0xa0000 + __djgpp_conventional_base);




  set_mode(TEXT_MODE);
   printf("\n\n\n \n\n\n \n\n\n \n\n\n \n\n\n \n\n\n \n\n\n \n\n\n \n\n\n \n\n\n


                        ͻ
                                Less1.c,by hrakann       
                                  press V to start         
                        ͼ
                        \n\n\n \n\n\n \n\n\n \n

                        =>=>type V=>=>");



   do
   {
      c = getchar();      /* get a character from the kb   */
   } while (c != 'V');
/*printf("pick 1,2,3,4 and press enter\n1=circles demo\n2=laser demo\n3=lines demo\n4=all demoz");
input(q);*/




set_mode(VGA_256_COLOR_MODE);		 /* set the video mode. */




		for(radius=0;radius<75;radius++)
		for(ii=0;ii<500;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=rand()%NUM_COLORS;
			circle_slow(x,y,radius,color);

		}

		for(radius=75;radius>0;radius--)
		for(ii=0;ii<250;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=1;
			circle_slow(x,y,radius,color);
		}
		for(radius=75;radius<100;radius++)
		for(ii=0;ii<250;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=2;
			circle_slow(x,y,radius,color);
		}
		for(radius=100;radius>74;radius--)
		for(ii=0;ii<250;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=5;
			circle_slow(x,y,radius,color);
		}
		for(radius=25;radius<101;radius++)
		for(ii=0;ii<250;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=4;
			circle_slow(x,y,radius,color);
		}
		for(radius=100;radius>0;radius--)
		for(ii=0;ii<250;ii++)
		{
			x=(SCREEN_WIDTH-radius*2)+radius;
			y=(SCREEN_HEIGHT-radius*2)+radius;
			color=0;
			circle_slow(x,y,radius,color);
		}



       set_mode(VGA_256_COLOR_MODE);

      for(ii=25;ii>0;ii--)
      {
         printf("laser=%d\n",ii);
         x2=rand()%SCREEN_WIDTH;
         y2=rand()%SCREEN_HEIGHT;


         for(i=0;i<99999;i++)
         {
            plot_pixel(x2,y2,6);
            plot_pixel(x2-1,y2,6);
            plot_pixel(x2-2,y2,6);
            plot_pixel(x2-3,y2,6);
            plot_pixel(x2+1,y2,6);
            plot_pixel(x2+2,y2,6);
            plot_pixel(x2+3,y2,6);
            plot_pixel(x2,y2-1,6);
            plot_pixel(x2,y2-2,6);
            plot_pixel(x2,y2-3,6);
            plot_pixel(x2,y2+1,6);
            plot_pixel(x2,y2+2,6);
            plot_pixel(x2,y2+3,6);
         }
         x1=1;
         y1=1;
         for(i=0;i<5000;i++)
         {
            color=rand()%NUM_COLORS;

            line_slow(x1,y1,x2,y2,color);

         }
            set_mode(VGA_256_COLOR_MODE);
      }
      for(i=0;i<75000;i++)
      {

         color=rand()%NUM_COLORS;
         x1=rand()%SCREEN_WIDTH;
         y1=rand()%SCREEN_HEIGHT;
         x2=rand()%SCREEN_WIDTH;
         y2=rand()%SCREEN_HEIGHT;

         line_slow(x1,y1,x2,y2,color);

      }




   printf("V and enter to end");
   do
   {
      c = getchar();
   }  while (c != 'V');





  set_mode(TEXT_MODE);				  /* set the video mode back to
                                         text mode. */
 __djgpp_nearptr_disable();
printf("Yo bitch,thisherez is shareware so pay up in thirty days.Distribute it as you wish.\nJust give me your soul you got for payment.\nzero123456@hotmail.com\nChronic\n%d,c");
   return;
   }





